/* Interface.h created by cwhite on Fri 30-Jan-1998 */

#import <AppKit/AppKit.h>

@protocol MCBinderProto

- (void)setModel:aModel;
- (void)setModelNoUpdate:aModel;
- (id)model;

- (void)updateModelFromInterface;
- (void)updateInterfaceFromModel;

@end


	/*	-------------------------------------------------------
                              Notifications
	    -------------------------------------------------------  */

// All Binders and TVCs listen for these
// Use AllBindersPerformSelector to choose a selector
#define AllBindersPerformNotification		@"AllBindersPerform"
#define	AllBindersPerformSelector		@"sel"

// Binding
#define BindingWillBindNotification		@"BindingWillBind"
#define BindingWillUnBindNotification		@"BindingWillUnBind"

#define BindingNotificationKey_RootAttribute	@"root_attribute"
#define BindingNotificationKey_LeafAttribute	@"leaf_attribute"
#define BindingNotificationKey_RootModel	@"root_model"
#define BindingNotificationKey_LeafModel	@"leaf_model"
#define BindingNotificationKey_Interface	@"interface"

// TVC
#define TVCWillSetModelNotification		@"TVCWillSetModel"
#define TVCWillUnSetModelNotification		@"TVCWillUnSetModel"
#define TVCWillBindColumnNotification		@"TVCWillBindColumn"
#define TVCWillUnBindColumnNotification		@"TVCWillUnBindColumn"

#define TVCNotificationKey_TableView		@"table_view"
#define TVCNotificationKey_TableColumn		@"table_column"
#define TVCNotificationKey_ListModel		@"list_model"
#define TVCNotificationKey_RootAttribute	@"root_attribute"
#define TVCNotificationKey_LeafAttribute	@"leaf_attribute"
#define TVCNotificationKey_SampleRootModel	@"root_model"
#define TVCNotificationKey_SampleLeafModel	@"leaf_model"
